// Define global variables
var SEARCHANY     = 1;
var SEARCHALL     = 2;
var SEARCHURL     = 4;
var searchType  = '';
var showMatches   = 400;
var currentMatch  = 0;
var copyArray   = new Array();

var originalQuery = '';

var docContent = '';
// eAIP specific variables

var countryCode = 'UA';
var languageCode = 'ru-RU'; 

var searchAreaDivId = "searchAreaDivId" // The Id of the Div element in the search page

// rest of content in _tail.  Next line should indicate a continuation.


// Continuation file required to work around windows batch script limitations

// Determine the type of search, and make
// sure the user has entered something
function validate(entry) {
	searchType = (document.forms[0].findAll.checked) ? SEARCHALL : SEARCHANY ; 
	originalQuery = entry; 
	while (entry.charAt(0) == ' ') 
	{
		entry = entry.substring(1,entry.length);
		document.forms[0].query.value = entry;
	}
	while (entry.charAt(entry.length - 1) == ' ') 
	{
		entry = entry.substring(0,entry.length - 1);
		document.forms[0].query.value = entry;
	}
	if (entry.length == 0) {
		document.forms[0].query.value = '';
		missingInput();
		return;
	}
	convertString(entry);
}

// Put the search terms in an array and
// and call appropriate search algorithm
function convertString(reentry) {
	var searchArray = reentry.split(" ");
	if (searchType == (SEARCHALL)) { requireAll(searchArray); }
	else { allowAny(searchArray); }
}

// Define a function to perform a search that requires
// a match of any of the terms the user provided
function allowAny(t) {
	var findings = new Array(0);
	for (i = 0; i < profiles.length; i++) 
	{
		var compareElement	= profiles[i].toUpperCase();
		var refineElement = (searchType == SEARCHANY) ? compareElement.substring(0,compareElement.indexOf('|FILE')) : 
			compareElement.substring(compareElement.indexOf('|FILE'), compareElement.length);
		for (j = 0; j < t.length; j++) 
		{
			var compareString = t[j].toUpperCase();
			if (refineElement.indexOf(compareString) != -1) 
			{
				findings[findings.length] = profiles[i];
				break;
			}
		}
	}
	verifyManage(findings);
}

// Define a function to perform a search that requires
// a match of all terms the user provided
function requireAll(t) {
	var findings = new Array();
	for (i = 0; i < profiles.length; i++) 
	{
		var allConfirmation = true;
		var allString = profiles[i].toUpperCase();
		var refineAllString = allString.substring(0,allString.indexOf('|FILE'));
		for (j = 0; j < t.length; j++) 
		{
			var allElement = t[j].toUpperCase();
			if (refineAllString.indexOf(allElement) == -1) 
			{
				allConfirmation = false;
				continue;
			}
		}
		if (allConfirmation) 
		{
			findings[findings.length] = profiles[i];
		}
	}
	verifyManage(findings);
}

// Determine whether the search was successful
// If so print the results; if not, indicate that, too
function verifyManage(resultSet) {
	if (resultSet.length == 0) { noMatch(); }
	else { copyArray = resultSet.sort(); formatResults(copyArray, currentMatch, showMatches); }
}

function missingInput() { // Define a function where no search items supplied
	document.getElementById(searchAreaDivId).innerHTML = '<br/><p>No search criteria supplied</p>';	 
}

// Define a function that indicates that the returned no results
function noMatch() {
	document.getElementById(searchAreaDivId).innerHTML = '<br/><p>The query "' + originalQuery	+ '" returned no results.</p></body>'; 
}




// Define a function to print the results of a successful search
function formatResults(results, reference, offset) {
	var currentRecord = (results.length < reference + offset ? results.length : reference + offset);
	var divContent = "" ;
	divContent += '<table width="90%" border="0" align="center" cellpadding="3">' ;
	divContent += '<tr><td><hr width="100%"/></td></tr>' ;
	divContent += '<tr><td valign="top"><b>' + results.length + ' documents found' + '</b>' + '\n\n\n\n\t';
	if (searchType == SEARCHURL) 
	{
		for (var i = reference; i < currentRecord; i++) 
		{
			var divide = results[i].split("|");
			divContent += '\t' + '<a href="' + divide[2] + '">' + divide[2] + '</a>' + '\t' + '<i>' + divide[1] + '</i><p>\n\n';
		}
	}
	else {
		for (var i = reference; i < currentRecord; i++) 
		{
			var divide = results[i].split('|');
			var dividedDocName = divide[0].split('*');
			//In IE8 we are getting garbage in the second split string if it should be empty
			if (dividedDocName[1].length <=3)
			{
				divContent += '\n\n\t' + '<div class="H2"><a target="eAISContent" href="' + divide[2].substring(5) ;
				divContent += '">' + '<span class="Number">' + dividedDocName[0] + '\t</span></a></div>\t<i></i>';
			}
			else if (dividedDocName[0].length <=4)
			{
				divContent += '\n\n\t' + '<div class="H2"><a target="eAISContent" href="' + divide[2].substring(5) ;
				divContent += '">' + '<span class="Number">' + dividedDocName[0] +'\t</span>\t' + dividedDocName[1] + '</a></div>\t<i></i>';
			}
			else
			{
				divContent += '\n\n\t' + '<div class="H2"><a target="eAISContent" href="' + divide[2].substring(5) ;
				divContent += '">' + '<span class="Number">' + dividedDocName[0] +'\t</span>' + dividedDocName[1] + '</a></div>\t<i></i>';
			}
		}
	}
	divContent += '\n\t\n\n\n\n';
	prevNextResults(results.length, reference, offset);
	divContent += '<hr width="100%"/>' + '\n</td></tr>\n</table>\n</body>\n</html>';
	document.getElementById(searchAreaDivId).innerHTML = divContent ;
}


// Define a function to dynamically display Prev and Next buttons
function prevNextResults(ceiling, reference, offset) {
	docContent += '<center>';
	if(reference > 0) 
	{
		docContent += '<input type="BUTTON" value="Prev ' + offset + ' Results" ' ;
		docContent += 'onClick="parent.frames[0].formatResults(parent.frames[0].copyArray, ' ;
		docContent += (reference - offset) + ', ' + offset + ')">';
	}
	if(reference >= 0 && reference + offset < ceiling) 
	{
		var trueTop = ((ceiling - (offset + reference) < offset) ? ceiling - (reference + offset) : offset);
		var howMany = (trueTop > 1 ? "s" : "");
		docContent += '<input type="BUTTON" value="Next ' + trueTop + ' Result' + howMany + '" ' ;
		docContent += 'onClick="parent.frames[0].formatResults(parent.frames[0].copyArray, ' ;
		docContent += (reference + offset) + ', ' + offset + ')">';
	}
	docContent += '</center>';
}

